#!/usr/bin/perl
###############

##
# tripper.pl v1.0  -  SNMP Network Scanner
# coded by ca0s / EZKRACHO Security Team
#
# mail: caos@ezkracho.com.ar 
# web: http://www.ezkracho.com.ar/
#
# Released under the terms of the GNU General Public License.
#
# This script requires Net::SNMP module, download it from CPAN.
# [ CPAN - http://search.cpan.org/ ]
#
# Simple script para escanear redes en busca de sistemas corriendo
# SNMP. Tiene varias opciones como marcar un time out, soporte de
# brute force con listas de palabras y mostrar una descripcion del
# sistema que encuentra. Usar la opcion '-h' para mas detalles.
#
# y admitanlo... Perl is kewl :)
##

use Getopt::Std;  # Viene con Perl         #
use Net::SNMP;    # Lo tienen que instalar # 

$version = "1.0";

getopts("hvdl:b:t:", \%args);

if (defined $args{h})
 { &Uso; }

if (defined $args{v})
 { $VERBOSE = 1; }

if (defined $args{d})
 { $INFO = 1; }

if (defined $args{l}) { 
    $logfile = $args{l};
    $LOGGING = 1;
    open(LOG, ">$logfile") or die("\n(!) Error opening log file.\n");
    print LOG " -- tripper.pl $version - ca0s [Ezkracho Team] - http://www.ezkracho.com.ar/\n\n";
    close(LOG);
}

if (defined $args{b})
 {
    $brutefile = $args{b};
    $BRUTE = 1;
} else {
    @communitys = (  # Por default solo busca por estos community's #
	'public',
	'private'
    );
}

if (defined $args{t}) {
    $timeout = $args{t};
} else {
    $timeout = 1;  # Time Out default es 1 segundo #
}

if ($#ARGV != 0) { &Uso; }

my $mibName = '1.3.6.1.2.1.1.5.0';   # System Name        #
my $mibDescr = '1.3.6.1.2.1.1.1.0';  # System Description #
my $mibUptime = '1.3.6.1.2.1.1.3.0'; # System Uptime      #

if (!$LOGGING) { 
    print " -- tripper.pl $version - ca0s [Ezkracho Team] - http://www.ezkracho.com.ar/\n";
}

Hackit($ARGV[0]); ## All start here ##


#############################
# Funcion ScAn              #
#############################
sub ScAn {
    my ($hostname) = @_;
    my @cty_found;
    my $lflag = 0;
    my $i = 0;

    if ($BRUTE) {
	open(BRU, $brutefile) or die("(!) Error opening $brutefile file.\n");
	while (<BRU>) {
    	    my ($ctybru) = $_;
	    chomp($ctybru);
	    if (($ret = &GetRequest($hostname, $ctybru, $mibUptime)) ne 1) {
		$lflag = 1;
		$cty_found[$i++] = $ctybru;
	    }
	}
	close(BRU);
    }
    else {
        foreach $cty (@communitys) {
	    if (($ret = &GetRequest($hostname, $cty, $mibUptime)) ne 1) {
		$lflag = 1;
		$cty_found[$i++] = $cty;
	    }
	}
    }

    if ($lflag) {
	if ($LOGGING) {
	    open(LOG, ">>$logfile") or die("\n(!) Error opening log file.\n");
	    print LOG "\n(*) [$hostname] --> Community Name Found: ";
	    foreach (@cty_found) {
		print LOG "'$_' ";
	    }
	    print LOG "\n";
	    if ($INFO) {
		&GetRequest($hostname, $cty_found[0], $mibName);	    
		print LOG " - SYSTEM NAME: $response->{$mibName}\n";
		&GetRequest($hostname, $cty_found[0], $mibUptime);
		print LOG " - SYSTEM UPTIME: $response->{$mibUptime}\n";
		&GetRequest($hostname, $cty_found[0], $mibDescr);
		printf LOG " - SYSTEM DESCRIPTION: $response->{$mibDescr}\n";
	    }
	    close(LOG);
	}
	else {
	    printf "\n(*) [%s] --> Community Name Found: ", $hostname;
	    foreach (@cty_found) {
		printf "'%s' ", $_;
	    }
	    print "\n";
	    if ($INFO) {
		&GetRequest($hostname, $cty_found[0], $mibName);
		printf " - SYSTEM NAME: %s\n", $response->{$mibName};
		&GetRequest($hostname, $cty_found[0], $mibUptime);
		printf " - SYSTEM UPTIME: %s\n", $response->{$mibUptime};
		&GetRequest($hostname, $cty_found[0], $mibDescr);
		printf " - SYSTEM DESCRIPTION: %s\n", $response->{$mibDescr};
	    }
	}
    }
    else {
	if ($VERBOSE and !$LOGGING) { 
	    printf "\n    [%s]: No Response.\n", $session->hostname();
	}
    }
    $session->close();
}


#############################
# Funcion GetRequest        #
#############################
sub GetRequest {
    my ($hostname) = $_[0];
    my ($community) = $_[1];
    my ($oid) = $_[2];

    ($session, $error) = Net::SNMP->session(
	-hostname  => $hostname,
	-community => $community,
	-port      => 161,
	-timeout   => $timeout
    );

    if (!defined($session)) {
	printf "\n(!) Error: %s.\n", $error;
    }

    if (!defined($response = $session->get_request($oid))) {
        return (1);
    }
    else { 
	return (0);
    }
}


#############################
# Funcion Hackit            #
#############################
sub Hackit {
    ($partA,$partB,$partC,$partD) = split /\./, $_[0];
    my @part_A = CheckIP($partA);
    my @part_B = CheckIP($partB);
    my @part_C = CheckIP($partC);
    my @part_D = CheckIP($partD);
    for ($cA = 0; $cA < @part_A; $cA++) {
	for ($cB = 0; $cB < @part_B; $cB++) {
	    for ($cC = 0; $cC < @part_C; $cC++) {
		for ($cD = 0; $cD < @part_D; $cD++) {
		    my $full_ip = "$part_A[$cA].$part_B[$cB].$part_C[$cC].$part_D[$cD]";
		    ScAn($full_ip); ## Call to ScAn function ##
		}
	    }
	}    
    }
}


#############################
# Funcion CheckIP           #
#############################
sub CheckIP {
    my ($parte) = @_;
    my (@retpart);
    my (@tmpart);
    my ($bed)=0;
    unless($parte =~ /\D/) {
	CheckRange($parte);
	$retpart[0] = $parte;
    } elsif($parte !~ /\-/ && $parte !~ /\*/ && $parte !~ /\,/) {
	&Uso;
    } elsif($parte =~ /\*/) {
	for($eko=0; $eko<=255; $eko++) { $retpart[$eko] = $eko; }
    } elsif($parte =~ /\,/) { 
	@tmpart = split(/\,/, $parte);
	foreach(@tmpart) {
	    unless($_ =~ /\D/) {
		CheckRange($_);
		$retpart[$bed] = $_;
		$bed++;
	    } elsif($_ =~ /(\d+)-(\d+)$/) {
	    	CheckRange($1);
		CheckRange($2);
		if($1 >= $2) { &Uso; }
		for($unf=$1; $unf<=$2; $unf++) {
		    $retpart[$bed] = $unf;
		    $bed++;   
		}
	    } else { &Uso; } 
	}    
    } elsif($parte =~ /(\d+)-(\d+)$/) {
    	CheckRange($1);
	CheckRange($2);
	if($1 >= $2) { &Uso; }
        for($unf=$1; $unf<=$2; $unf++) {
	    $retpart[$bed] = $unf;
	    $bed++;   
	}
    } else { &Uso; }
    @retpart;
}


#############################
# Funcion CheckRange        #
#############################
sub CheckRange {
    my ($uff) = @_;
    if ($uff < 0 or $uff > 255) {
        print "\n(!) ERROR: IP Address Out of Range (0-255).\n";
	&Uso;
    }
}


#############################
# Funcion Uso               #
#############################
sub Uso {
    print " -- tripper.pl $version - ca0s [Ezkracho Team] - http://www.ezkracho.com.ar/\n";
    print "\nUsage: $0 [Options] <host or net list>\n\n";
    print "[Options]\n";
    print " -d description. Print the system type from the SNMP MIB.\n";    
    print " -b <file> brute force community's via word list.\n";
    print " -t <seconds> time out. (default 1 second)\n";
    print " -l <file> log to file instead of stdout.\n";
    print " -v verbose. Print more information.\n";
    print " -h this help.\n\n";
    print "<host or net list>\n";
    print " * for the 256 possibilities.\n";
    print " , to separate single numbers.\n";
    print " - to set number ranges.\n\n";
    exit 1;
}
